/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.reflection.world.biome.BiomeReflection;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class NPCSpawning {
    private static final Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
    private static boolean pWGS = false;
    private static boolean fCFS = false;

    public static void performWorldGenSpawning(WorldServer world, int x, int z, Random rand) {
        CustomNPCsScheduler.runTack(() -> {
            if (pWGS || world == null) {
                return;
            }
            CustomNpcs.debugData.start(null);
            pWGS = true;
            Biome biome = world.getBiomeForCoordsBody(new BlockPos(x + 8, 0, z + 8));
            SpawnData data = SpawnController.instance.getRandomSpawnData(BiomeReflection.getBiomeName(biome));
            if (data == null || data.group <= 0 || rand.nextFloat() > (float)data.field_76292_a / 100.0f) {
                pWGS = false;
                CustomNpcs.debugData.end(null);
                return;
            }
            Entity entity = null;
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)data.compoundEntity, (World)world);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (!(entity instanceof EntityLiving)) {
                pWGS = false;
                CustomNpcs.debugData.end(null);
                return;
            }
            Entity finalEntity = entity;
            NPCSpawning.trySummonToPos(3, data, world, world.func_175672_r(new BlockPos(x + rand.nextInt(16), 0, z + rand.nextInt(16))), (EntityLiving)finalEntity);
            pWGS = false;
            CustomNpcs.debugData.end(null);
        });
    }

    public static void findChunksForSpawning(WorldServer world) {
        CustomNPCsScheduler.runTack(() -> {
            if (fCFS || SpawnController.instance.data.isEmpty() || world.func_72912_H().func_82573_f() % 100L != 0L) {
                return;
            }
            CustomNpcs.debugData.start(null);
            fCFS = true;
            try {
                eligibleChunksForSpawning.clear();
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
                    if (entityplayer.func_175149_v()) continue;
                    int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                    int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                    int size = 7;
                    for (int x = -size; x <= size; ++x) {
                        for (int z = -size; z <= size; ++z) {
                            PlayerChunkMapEntry playerinstance;
                            ChunkPos chunkcoordintpair = new ChunkPos(x + j, z + k);
                            if (eligibleChunksForSpawning.contains(chunkcoordintpair) || !world.func_175723_af().func_177730_a(chunkcoordintpair) || (playerinstance = world.func_184164_w().func_187301_b(chunkcoordintpair.field_77276_a, chunkcoordintpair.field_77275_b)) == null || !playerinstance.func_187274_e()) continue;
                            eligibleChunksForSpawning.add(chunkcoordintpair);
                        }
                    }
                }
                ArrayList<ChunkPos> tmp = new ArrayList<ChunkPos>(eligibleChunksForSpawning);
                Collections.shuffle(tmp);
                for (ChunkPos chunkcoordintpair2 : tmp) {
                    BlockPos chunkposition = NPCSpawning.getChunk((World)world, chunkcoordintpair2.field_77276_a, chunkcoordintpair2.field_77275_b);
                    int range = 6;
                    int posX = chunkposition.func_177958_n() + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
                    int posZ = chunkposition.func_177952_p() + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
                    BlockPos randomPos = new BlockPos(posX, chunkposition.func_177956_o(), posZ);
                    String name = BiomeReflection.getBiomeName(world.getBiomeForCoordsBody(randomPos));
                    SpawnData data = SpawnController.instance.getRandomSpawnData(name);
                    if (data == null || data.group <= 0 || world.field_73012_v.nextFloat() > (float)data.field_76292_a / 100.0f) continue;
                    Entity entity = null;
                    try {
                        entity = EntityList.func_75615_a((NBTTagCompound)data.compoundEntity, (World)world);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    if (!(entity instanceof EntityLiving)) continue;
                    NPCSpawning.trySummonToPos(1, data, world, randomPos, (EntityLiving)entity);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            fCFS = false;
            CustomNpcs.debugData.end(null);
        });
    }

    private static void trySummonToPos(int maxTries, @Nonnull SpawnData data, @Nonnull WorldServer world, @Nonnull BlockPos startPos, @Nonnull EntityLiving entity) {
        int[] sizes = NPCSpawning.getEntitySizes((World)world);
        if (entity instanceof EntityNPCInterface ? sizes[0] > 70 : (entity instanceof EntityAnimal ? sizes[1] > 10 : (entity instanceof EntityMob ? sizes[2] > 70 : sizes[3] > 50))) {
            return;
        }
        for (int summonTry = 0; summonTry < maxTries; ++summonTry) {
            BlockPos pos = NPCSpawning.getSpawnLocation(data, entity, world, startPos);
            if (pos == null) continue;
            boolean inSpawned = false;
            for (int i = 0; i < data.group; ++i) {
                Entity e;
                try {
                    e = EntityList.func_75615_a((NBTTagCompound)data.compoundEntity, (World)world);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (!(e instanceof EntityLiving) || !NPCSpawning.checkEntitySize(world, e, pos, data)) continue;
                NPCSpawning.spawnData((EntityLiving)e, (World)world, pos);
                inSpawned = true;
            }
            if (inSpawned) break;
        }
    }

    private static BlockPos getSpawnLocation(SpawnData data, EntityLiving entity, WorldServer world, BlockPos startPos) {
        if (data == null || world == null) {
            return null;
        }
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                if (y + startPos.func_177956_o() < 3 || y + startPos.func_177956_o() > 250) continue;
                for (int z = -radius; z <= radius; ++z) {
                    Event.Result canSpawn;
                    BlockPos checkPos = startPos.func_177982_a(x, y, z);
                    if (!world.func_175726_f(checkPos).func_177410_o() || data.type == 1 && world.func_175699_k(checkPos) > 8 || data.type == 2 && world.func_175699_k(checkPos) <= 8) continue;
                    entity.field_70165_t = (double)checkPos.func_177958_n() + 0.5;
                    entity.field_70161_v = (double)checkPos.func_177952_p() + 0.5;
                    entity.field_70163_u = checkPos.func_177956_o();
                    boolean isSpawnPos = false;
                    BlockPos posDown = checkPos.func_177977_b();
                    BlockPos posUp = checkPos.func_177981_b((int)Math.floor(entity.func_70047_e()));
                    IBlockState state = world.func_180495_p(checkPos);
                    IBlockState stateDown = world.func_180495_p(posDown);
                    IBlockState stateUp = world.func_180495_p(posUp);
                    if (data.liquid) {
                        isSpawnPos = state.func_185904_a().func_76224_d() && stateDown.func_185904_a().func_76224_d() && stateUp.func_185904_a().func_76224_d() || !stateUp.func_185915_l();
                    } else if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).ais.getNavigationType() == 1) {
                        isSpawnPos = !(state.func_185915_l() && !state.func_177230_c().isAir(state, (IBlockAccess)world, checkPos) || stateDown.func_185915_l() && !stateDown.func_177230_c().isAir(stateDown, (IBlockAccess)world, posDown) || stateUp.func_185915_l() && !stateUp.func_177230_c().isAir(stateUp, (IBlockAccess)world, posUp));
                    } else if (stateDown.func_177230_c() != Blocks.field_150357_h && stateDown.func_177230_c() != Blocks.field_180401_cv) {
                        boolean bl = isSpawnPos = !state.func_185915_l() && !state.func_185904_a().func_76224_d() && stateDown.func_177230_c().canCreatureSpawn(stateDown, (IBlockAccess)world, posDown, EntityLiving.SpawnPlacementType.ON_GROUND) && (!stateUp.func_185915_l() || stateUp.func_177230_c().isAir(stateUp, (IBlockAccess)world, posUp));
                    }
                    if (isSpawnPos) {
                        for (EntityPlayer player : world.field_73010_i) {
                            if (player.func_175149_v()) {
                                isSpawnPos = false;
                                break;
                            }
                            double dist = player.func_70032_d((Entity)entity);
                            if (dist > PlayerData.get((EntityPlayer)player).game.renderDistance + 16.0) {
                                isSpawnPos = false;
                                break;
                            }
                            if (dist < 12.0) {
                                isSpawnPos = false;
                                break;
                            }
                            if (data.canSeeSummon != Util.instance.npcCanSeeTarget((EntityLivingBase)player, (EntityLivingBase)entity, false, true)) {
                                isSpawnPos = false;
                                break;
                            }
                            List<EntityLiving> list = Util.instance.getEntitiesWithinDist(EntityLiving.class, (World)world, checkPos, 160.0);
                            int count = list.size();
                            if (entity instanceof EntityNPCInterface) {
                                count = 0;
                                for (Entity entity2 : list) {
                                    if (!(entity2 instanceof EntityNPCInterface) || ((EntityNPCInterface)entity2).stats.spawnCycle != 4) continue;
                                    ++count;
                                }
                            }
                            if (count < data.maxNearPlayer) continue;
                            isSpawnPos = false;
                            break;
                        }
                    }
                    if (!isSpawnPos || (canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) == Event.Result.DENY || canSpawn == Event.Result.DEFAULT && !entity.func_70601_bi()) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    private static boolean checkEntitySize(WorldServer world, Entity entity, BlockPos pos, @Nonnull SpawnData data) {
        List<?> list = Util.instance.getEntitiesWithinDist(entity.getClass(), (World)world, pos, (double)data.range);
        int count = list.size();
        if (entity instanceof EntityNPCInterface) {
            count = 0;
            for (Entity e : list) {
                if (!(e instanceof EntityNPCInterface) || ((EntityNPCInterface)e).stats.spawnCycle != 4) continue;
                ++count;
            }
        }
        return count <= data.group;
    }

    private static int[] getEntitySizes(World world) {
        int[] sizes = new int[4];
        for (Entity e : world.field_72996_f) {
            if (!e.func_70089_S()) continue;
            if (e instanceof EntityNPCInterface) {
                if (((EntityNPCInterface)e).stats.spawnCycle != 4) continue;
                sizes[0] = sizes[0] + 1;
                continue;
            }
            if (e instanceof EntityAnimal) {
                sizes[1] = sizes[1] + 1;
                continue;
            }
            if (e instanceof EntityMob) {
                sizes[2] = sizes[2] + 1;
                continue;
            }
            sizes[3] = sizes[3] + 1;
        }
        return sizes;
    }

    protected static BlockPos getChunk(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int posX = x * 16 + world.field_73012_v.nextInt(16);
        int posZ = z * 16 + world.field_73012_v.nextInt(16);
        int y = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(posX, 0, posZ)) + 1), (int)16);
        int posY = world.field_73012_v.nextInt(y > 0 ? y : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(posX, posY, posZ);
    }

    private static void spawnData(EntityLiving entity, World world, BlockPos pos) {
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.stats.spawnCycle = 4;
            npc.stats.respawnTime = 0;
            npc.ais.returnToStart = false;
            npc.ais.setStartPos(pos);
        }
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)entity);
    }
}

